/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.err.InformerSqlException;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.queue.DatabaseFunctionsKt;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import java.rmi.RemoteException;
import java.sql.SQLException;
import psdi.mbo.Mbo;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXException;

public class CatalogData
extends Mbo {
    public CatalogData(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void save() throws RemoteException, MXException {
        if (this.getMboValue("HASH").isModified()) {
            MboSetRemote pushRegSet;
            long newSequence = this.updateSequence();
            this.setValue("SEQUENCE", newSequence, 2L);
            this.setValue("CHANGEDATE", MXServer.getMXServer().getDate());
            if (this.getBoolean("CATALOG.INITIALIZED") && !(pushRegSet = this.getMboSet("$pushregcheck", "ISPUSHREG", "notifyid = :catalog.notifyid")).isEmpty()) {
                if (!this.isNull("PARTITIONNAME")) {
                    PushQueueManager.getInstance().addQueuedItemForCatalog(-1L, this.getString("CATALOG.NOTIFY.NOTIFYNUM"), this.getString("CATALOG.CATALOG"), this.getString("PARTITIONNAME"), this.getString("LANGCODE"));
                }
                if (this.getBoolean("MAINRECORD")) {
                    PushQueueManager.getInstance().addQueuedItemForCatalog(-1L, this.getString("CATALOG.NOTIFY.NOTIFYNUM"), this.getString("CATALOG.CATALOG"), null, this.getString("LANGCODE"));
                }
            }
        }
        super.save();
    }

    private long updateSequence() throws RemoteException, MXException {
        try {
            return DataUtils.systemDbConn((conn, dbtype) -> DatabaseFunctionsKt.nextSequenceValue(conn, "ISCATALOGDATASEQ"));
        }
        catch (SQLException e) {
            throw new InformerSqlException("Failed to increment Catalog sequence number", e);
        }
    }
}

