/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.tools;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;

public class InformerEnvSetup {
    public static void main(String[] args) {
        JSAP jsap = new JSAP();
        FlaggedOption argWebXMLPath = new FlaggedOption("webxmlpath").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault("./../../applications/maximo/maximouiweb/webmodule/WEB-INF/web.xml").setRequired(false).setShortFlag('x').setLongFlag("xmlpath");
        argWebXMLPath.setHelp("The path to the Maximo UI web.xml.");
        FlaggedOption argMeawebXMLPath = new FlaggedOption("meawebxmlpath").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault("./../../applications/maximo/meaweb/webmodule/WEB-INF/web.xml").setRequired(false).setShortFlag('m').setLongFlag("meaweb");
        argMeawebXMLPath.setHelp("The path to the Maximo MEA Web web.xml.");
        FlaggedOption argPropertiesPath = new FlaggedOption("propertypath").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault("./../../applications/maximo/properties/maximo.properties").setRequired(false).setShortFlag('p').setLongFlag("proppath");
        argPropertiesPath.setHelp("The path to the Maximo properties.");
        FlaggedOption argLibsPath = new FlaggedOption("libspath").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault("./../../applications/maximo/lib/").setRequired(false).setShortFlag('l').setLongFlag("libspath");
        argLibsPath.setHelp("The path to the primary Maximo libraries directory.");
        FlaggedOption argRMPropPath = new FlaggedOption("rmproppath").setStringParser((StringParser)JSAP.STRING_PARSER).setDefault("./../../applications/trm/RulesManager/RulesManager.properties").setRequired(false).setShortFlag('r').setLongFlag("rmproppath");
        argRMPropPath.setHelp("The path to the Rules Manager properties.");
        Switch argHelpSwitch = new Switch("help").setLongFlag("help").setShortFlag('h');
        argHelpSwitch.setHelp("Print this help information.");
        try {
            jsap.registerParameter((Parameter)argWebXMLPath);
            jsap.registerParameter((Parameter)argMeawebXMLPath);
            jsap.registerParameter((Parameter)argPropertiesPath);
            jsap.registerParameter((Parameter)argLibsPath);
            jsap.registerParameter((Parameter)argRMPropPath);
            jsap.registerParameter((Parameter)argHelpSwitch);
            JSAPResult config = jsap.parse(args);
            if (config.getBoolean("help")) {
                System.out.println(jsap.getHelp());
                System.exit(1);
            }
            InformerEnvSetup ies = new InformerEnvSetup();
            ies.removeOldLibraries(config.getString("libspath"));
            ies.updateMaximoUIWeb(config.getString("webxmlpath"));
            ies.updateRulesManagerIgnoreObjects(config.getString("rmproppath"));
            String libsPath = config.getString("libspath");
            File libsDir = new File(libsPath);
            if (!libsDir.exists() || !libsDir.isDirectory()) {
                throw new IllegalArgumentException("Maximo libraries file path is invalid: " + libsDir);
            }
            ies.phaseOutSupportCron(libsDir);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace(System.err);
            System.out.println(jsap.getHelp());
            System.exit(1);
        }
    }

    public void updateMaximoUIWeb(String webXMLPath) throws Exception {
        Object out;
        Element servletMapping;
        Element servlet;
        Element e;
        int servletMappingIndex;
        int servletIndex;
        int i;
        List content;
        boolean needsServletMap;
        if (webXMLPath == null) {
            System.out.println("Cannot register the Informer servlet because a path to the Maximo UI Application web.xml was not provided.");
            return;
        }
        System.out.println("Updating the web.xml at " + webXMLPath);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new File(webXMLPath));
        JDOMXPath xpath = new JDOMXPath("//ns:servlet[ns:servlet-name='NotifyExport']");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ns", doc.getRootElement().getNamespaceURI());
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
        boolean needsServlet = xpath.selectNodes((Object)doc).size() < 1;
        xpath = new JDOMXPath("//ns:servlet-mapping[ns:servlet-name='NotifyExport']");
        map = new HashMap();
        map.put("ns", doc.getRootElement().getNamespaceURI());
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
        boolean bl = needsServletMap = xpath.selectNodes((Object)doc).size() < 1;
        if (!needsServletMap && !needsServletMap) {
            System.out.println("The Informer servlet was found to be already registered, skipping registration.");
        } else {
            content = doc.getRootElement().getContent();
            i = 0;
            servletIndex = 0;
            servletMappingIndex = 0;
            for (Object o : content) {
                ++i;
                if (!(o instanceof Element)) continue;
                e = (Element)o;
                if (e.getName().equalsIgnoreCase("servlet") && servletIndex == 0) {
                    servletIndex = i - 1;
                    continue;
                }
                if (!e.getName().equalsIgnoreCase("servlet-mapping") || servletMappingIndex != 0) continue;
                servletMappingIndex = i;
                break;
            }
            if (needsServlet) {
                System.out.println("Registering Informer servlet.");
                servlet = new Element("servlet", doc.getRootElement().getNamespaceURI());
                servlet.addContent((Content)new Element("description", doc.getRootElement().getNamespaceURI()).setText("Informer Servlet"));
                servlet.addContent((Content)new Element("servlet-name", doc.getRootElement().getNamespaceURI()).setText("NotifyExport"));
                servlet.addContent((Content)new Element("servlet-class", doc.getRootElement().getNamespaceURI()).setText("com.interlocsolutions.maximo.webclient.servlet.NotifyServlet"));
                doc.getRootElement().addContent(servletIndex, (Content)servlet);
            }
            if (needsServletMap) {
                System.out.println("Registering Informer servlet mapping.");
                servletMapping = new Element("servlet-mapping", doc.getRootElement().getNamespaceURI());
                servletMapping.addContent((Content)new Element("servlet-name", doc.getRootElement().getNamespaceURI()).setText("NotifyExport"));
                servletMapping.addContent((Content)new Element("url-pattern", doc.getRootElement().getNamespaceURI()).setText("/notifyexport/*"));
                doc.getRootElement().addContent(servletMappingIndex, (Content)servletMapping);
            }
            out = new XMLOutputter(Format.getPrettyFormat());
            out.output(doc, (OutputStream)new FileOutputStream(webXMLPath));
            System.out.println("Successfully registered the Informer servlet.");
        }
        builder = new SAXBuilder();
        doc = builder.build(new File(webXMLPath));
        xpath = new JDOMXPath("//ns:servlet[ns:servlet-name='NotifyAppDeploy']");
        map = new HashMap();
        map.put("ns", doc.getRootElement().getNamespaceURI());
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
        needsServlet = xpath.selectNodes((Object)doc).size() < 1;
        xpath = new JDOMXPath("//ns:servlet-mapping[ns:servlet-name='NotifyAppDeploy']");
        map = new HashMap();
        map.put("ns", doc.getRootElement().getNamespaceURI());
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
        boolean bl2 = needsServletMap = xpath.selectNodes((Object)doc).size() < 1;
        if (!needsServletMap && !needsServletMap) {
            System.out.println("The Informer app deployment servlet was found to be already registered, skipping registration.");
            return;
        }
        content = doc.getRootElement().getContent();
        i = 0;
        servletIndex = 0;
        servletMappingIndex = 0;
        for (Object o : content) {
            ++i;
            if (!(o instanceof Element)) continue;
            e = (Element)o;
            if (e.getName().equalsIgnoreCase("servlet") && servletIndex == 0) {
                servletIndex = i - 1;
                continue;
            }
            if (!e.getName().equalsIgnoreCase("servlet-mapping") || servletMappingIndex != 0) continue;
            servletMappingIndex = i;
            break;
        }
        if (needsServlet) {
            System.out.println("Registering Informer app deployment servlet.");
            servlet = new Element("servlet", doc.getRootElement().getNamespaceURI());
            servlet.addContent((Content)new Element("description", doc.getRootElement().getNamespaceURI()).setText("Informer Application Deployment Servlet"));
            servlet.addContent((Content)new Element("servlet-name", doc.getRootElement().getNamespaceURI()).setText("NotifyAppDeploy"));
            servlet.addContent((Content)new Element("servlet-class", doc.getRootElement().getNamespaceURI()).setText("com.interlocsolutions.maximo.webclient.servlet.AppDeployServlet"));
            doc.getRootElement().addContent(servletIndex, (Content)servlet);
        }
        if (needsServletMap) {
            System.out.println("Registering Informer application deployment servlet mapping.");
            servletMapping = new Element("servlet-mapping", doc.getRootElement().getNamespaceURI());
            servletMapping.addContent((Content)new Element("servlet-name", doc.getRootElement().getNamespaceURI()).setText("NotifyAppDeploy"));
            servletMapping.addContent((Content)new Element("url-pattern", doc.getRootElement().getNamespaceURI()).setText("/informer/apps/*"));
            doc.getRootElement().addContent(servletMappingIndex, (Content)servletMapping);
        }
        out = new XMLOutputter(Format.getPrettyFormat());
        out.output(doc, (OutputStream)new FileOutputStream(webXMLPath));
        System.out.println("Successfully registered the Informer application deployment servlet.");
    }

    public void phaseOutSupportCron(@NotNull File libsDir) throws IOException {
        boolean supportLibsDeleted = false;
        File[] dirContents = libsDir.listFiles();
        if (dirContents == null) {
            throw new IOException("Contents of library folder " + libsDir + " could not be enumerated");
        }
        for (File libFile : dirContents) {
            String name = libFile.getName();
            if (!name.startsWith("informer-support") || !name.endsWith(".jar")) continue;
            boolean deleteSuccessful = libFile.delete();
            if (!deleteSuccessful) {
                throw new IOException("Deletion of " + libFile + "failed");
            }
            supportLibsDeleted = true;
            System.out.println("Deleted " + libFile);
        }
        if (!supportLibsDeleted) {
            System.out.println("No instance of a support library was found in the libraries folder. No action is necessary.");
        }
    }

    public void updateRulesManagerIgnoreObjects(String rmProp) throws IOException, ConfigurationException {
        if (rmProp == null) {
            System.out.println("Cannot update the Rules Manager ignore objects because a path to the RulesManager.properties was not provided.");
            return;
        }
        File rmPropFile = new File(rmProp);
        if (!rmPropFile.exists()) {
            System.out.println("No Rules Manager property file found at " + rmPropFile + " ; object ignore list will not be updated.");
            return;
        }
        System.out.println("Updating the " + rmProp);
        PropertiesConfiguration envSetupProps = new PropertiesConfiguration();
        envSetupProps.load(InformerEnvSetup.class.getClassLoader().getResource("com/interlocsolutions/maximo/tools/InformerEnvSetup.properties"));
        List informerObjects = envSetupProps.getList("rm.objects.ignored");
        PropertiesConfiguration rmConfig = new PropertiesConfiguration();
        PropertiesConfigurationLayout layout = new PropertiesConfigurationLayout(rmConfig);
        try (FileInputStream file = new FileInputStream(rmPropFile);
             InputStreamReader reader = new InputStreamReader(file);){
            layout.load((Reader)reader);
        }
        String ignoredKey = "rm.objects.ignored";
        ArrayList<String> ignoredObjects = new ArrayList<String>(rmConfig.getList("rm.objects.ignored"));
        for (String informerObject : informerObjects) {
            if (ignoredObjects.contains(informerObject)) continue;
            ignoredObjects.add(informerObject);
        }
        rmConfig.setProperty("rm.objects.ignored", ignoredObjects);
        try (FileWriter writer = new FileWriter(rmPropFile, false);){
            layout.save((Writer)writer);
        }
        System.out.println("Successfully added Informer objects to Rules Manager ignored objects list.");
    }

    public void removeOldLibraries(String libDirectory) {
        String[] filesToRemove;
        for (String jar : filesToRemove = new String[]{"kotlin-stdlib.jar", "kotlin-stdlib-common.jar"}) {
            Path jarFile = Paths.get(libDirectory, jar);
            try {
                if (Files.deleteIfExists(jarFile)) {
                    System.out.println("Removed old library " + jar + ".");
                    continue;
                }
                System.out.println("The library " + jar + " does not exist.  Skipping.");
            }
            catch (IOException e) {
                System.out.println("Error removing library " + jar + ". " + e.getMessage());
            }
        }
    }
}

