/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.tools;

import com.interlocsolutions.maximo.notify.util.ConnectionCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.Log4jAdapterKt;
import com.interlocsolutions.maximo.notify.util.ScriptRunner;
import com.interlocsolutions.maximo.notify.util.StatementCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.MXException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J \u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0006H\u0002J*\u0010'\u001a\u00020\u001a\"\u0004\b\u0000\u0010(2\u0006\u0010$\u001a\u00020\u00062\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002H(0*H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/interlocsolutions/maximo/tools/InformerDbSetup;", "", "params", "Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params;", "(Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params;)V", "QUEUE_TABLESET_NAME", "", "getQUEUE_TABLESET_NAME", "()Ljava/lang/String;", "SCHEMAVERSION", "", "getSCHEMAVERSION", "()I", "SCHEMA_NAME", "getSCHEMA_NAME", "setSCHEMA_NAME", "(Ljava/lang/String;)V", "STATUS_FAILED", "getSTATUS_FAILED", "STATUS_READY", "getSTATUS_READY", "STATUS_UPGRADING", "getSTATUS_UPGRADING", "getParams", "()Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params;", "createAllTables", "", "conn", "Ljava/sql/Connection;", "dbServerType", "Lcom/interlocsolutions/maximo/notify/util/db/DbServerType;", "createOrUpgradeSchema", "serverType", "dropAllTables", "execute", "runScript", "scriptName", "setSchemaInstallationStatus", "status", "useScript", "R", "block", "Lkotlin/Function1;", "Ljava/io/Reader;", "Companion", "Params", "TerminatingException", "isinformer-tools"})
public final class InformerDbSetup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Params params;
    @NotNull
    private final String STATUS_READY;
    @NotNull
    private final String STATUS_UPGRADING;
    @NotNull
    private final String STATUS_FAILED;
    private final int SCHEMAVERSION;
    @Nullable
    private String SCHEMA_NAME;
    @NotNull
    private final String QUEUE_TABLESET_NAME;
    @NotNull
    private static final Logger LOGGER;

    public InformerDbSetup(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.params = params;
        this.STATUS_READY = "READY";
        this.STATUS_UPGRADING = "UPGRADING";
        this.STATUS_FAILED = "FAILED";
        this.SCHEMAVERSION = 1;
        this.SCHEMA_NAME = "";
        this.QUEUE_TABLESET_NAME = "QUEUE";
    }

    @NotNull
    public final Params getParams() {
        return this.params;
    }

    @NotNull
    public final String getSTATUS_READY() {
        return this.STATUS_READY;
    }

    @NotNull
    public final String getSTATUS_UPGRADING() {
        return this.STATUS_UPGRADING;
    }

    @NotNull
    public final String getSTATUS_FAILED() {
        return this.STATUS_FAILED;
    }

    public final int getSCHEMAVERSION() {
        return this.SCHEMAVERSION;
    }

    @Nullable
    public final String getSCHEMA_NAME() {
        return this.SCHEMA_NAME;
    }

    public final void setSCHEMA_NAME(@Nullable String string) {
        this.SCHEMA_NAME = string;
    }

    @NotNull
    public final String getQUEUE_TABLESET_NAME() {
        return this.QUEUE_TABLESET_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execute() {
        Properties properties;
        LOGGER.info((Object)("Attempting to connect using " + this.params.getJdbcURL()));
        Properties $this$execute_u24lambda_u241 = properties = new Properties();
        boolean bl = false;
        Params.UserCreds userCreds = this.params.getUserInfo();
        if (userCreds != null) {
            Params.UserCreds it = userCreds;
            boolean bl2 = false;
            $this$execute_u24lambda_u241.put("user", it.getUsername());
            $this$execute_u24lambda_u241.put("password", it.getUserPassword());
        }
        Properties connectionProps = properties;
        LOGGER.info((Object)("JDBC String: " + this.params.getJdbcURL()));
        if (StringsKt.startsWith$default((String)this.params.getJdbcURL(), (String)"jdbc:sqlite:", (boolean)false, (int)2, null)) {
            Class.forName("org.sqlite.JDBC");
        } else if (StringsKt.startsWith$default((String)this.params.getJdbcURL(), (String)"jdbc:oracle:", (boolean)false, (int)2, null)) {
            Class.forName("oracle.jdbc.OracleDriver");
        } else if (StringsKt.startsWith$default((String)this.params.getJdbcURL(), (String)"jdbc:db2:", (boolean)false, (int)2, null)) {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        } else if (StringsKt.startsWith$default((String)this.params.getJdbcURL(), (String)"jdbc:mysql:", (boolean)false, (int)2, null)) {
            Class.forName("com.mysql.jdbc.Driver");
        } else if (StringsKt.startsWith$default((String)this.params.getJdbcURL(), (String)"jdbc:sqlserver:", (boolean)false, (int)2, null)) {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        } else if (StringsKt.startsWith$default((String)this.params.getJdbcURL(), (String)"jdbc:postgresql:", (boolean)false, (int)2, null)) {
            Class.forName("org.postgresql.Driver");
        }
        Connection $this$use$iv = DriverManager.getConnection(this.params.getJdbcURL(), connectionProps);
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)new ConnectionCloseableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            DbServerType serverType;
            ConnectionCloseableWrapper it$iv = (ConnectionCloseableWrapper)closeable;
            boolean bl3 = false;
            Connection conn = $this$use$iv;
            boolean bl4 = false;
            conn.setAutoCommit(true);
            DbServerType dbServerType = serverType = DbServerType.identify((Connection)conn);
            switch (dbServerType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dbServerType.ordinal()]) {
                case 1: {
                    System.out.println((Object)("Connected to " + conn.getMetaData().getDatabaseProductName() + " version " + conn.getMetaData().getDatabaseProductVersion()));
                    Statement $this$use$iv2 = conn.createStatement();
                    boolean $i$f$use2 = false;
                    Closeable closeable2 = (Closeable)new StatementCloseableWrapper($this$use$iv2);
                    Throwable throwable2 = null;
                    try {
                        StatementCloseableWrapper it$iv2 = (StatementCloseableWrapper)closeable2;
                        boolean bl5 = false;
                        Statement statement = $this$use$iv2;
                        boolean bl6 = false;
                        statement.execute("PRAGMA synchronous = OFF");
                        boolean bl7 = statement.execute("PRAGMA journal_mode = MEMORY");
                        break;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                case 2: {
                    System.out.println((Object)("Connected to " + conn.getMetaData().getDatabaseProductName() + " version " + conn.getMetaData().getDatabaseProductVersion()));
                    break;
                }
                case 3: {
                    System.out.println((Object)("Connected to " + conn.getMetaData().getDatabaseProductName() + " version " + conn.getMetaData().getDatabaseProductVersion()));
                    Intrinsics.checkNotNullExpressionValue((Object)conn, (String)"conn");
                    this.SCHEMA_NAME = JDBCExtensionsKt.queryForString$default((Connection)conn, (String)"SELECT current_schema FROM SYSIBM.dual", null, (int)2, null);
                    break;
                }
                case 4: {
                    System.out.println((Object)("Connected to " + conn.getMetaData().getDatabaseProductName() + " version " + conn.getMetaData().getDatabaseProductVersion()));
                    Intrinsics.checkNotNullExpressionValue((Object)conn, (String)"conn");
                    this.SCHEMA_NAME = JDBCExtensionsKt.queryForString$default((Connection)conn, (String)"SELECT database()", null, (int)2, null);
                    break;
                }
                case 5: {
                    System.out.println((Object)("Connected to " + conn.getMetaData().getDatabaseProductName() + " version " + conn.getMetaData().getDatabaseProductVersion()));
                    Intrinsics.checkNotNullExpressionValue((Object)conn, (String)"conn");
                    this.SCHEMA_NAME = JDBCExtensionsKt.queryForString$default((Connection)conn, (String)"SELECT SCHEMA_NAME()", null, (int)2, null);
                    break;
                }
                case 6: {
                    System.out.println((Object)("Connected to " + conn.getMetaData().getDatabaseProductName() + " version " + conn.getMetaData().getDatabaseProductVersion()));
                    Intrinsics.checkNotNullExpressionValue((Object)conn, (String)"conn");
                    this.SCHEMA_NAME = JDBCExtensionsKt.queryForString$default((Connection)conn, (String)"SELECT current_schema()", null, (int)2, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(conn.getMetaData().getDatabaseProductName() + " is not supported");
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)conn, (String)"conn");
            Intrinsics.checkNotNullExpressionValue((Object)serverType, (String)"serverType");
            this.createOrUpgradeSchema(conn, serverType);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void createOrUpgradeSchema(Connection conn, DbServerType serverType) throws RemoteException, MXException, SQLException {
        boolean bl;
        Integer existingSchemaVersion = null;
        int n = WhenMappings.$EnumSwitchMapping$0[serverType.ordinal()];
        switch (n) {
            case 2: {
                bl = JDBCExtensionsKt.queryForExists$default((Connection)conn, (String)"SELECT 1 FROM all_objects WHERE object_type = 'TABLE' AND object_name = 'ISRAWSCHEMAVERSION'", null, (int)2, null);
                break;
            }
            case 3: {
                bl = JDBCExtensionsKt.queryForExists$default((Connection)conn, (String)("SELECT 1 FROM SYSIBM.systables WHERE TYPE = 'T' AND name = 'ISRAWSCHEMAVERSION' AND creator = '" + this.SCHEMA_NAME + '\''), null, (int)2, null);
                break;
            }
            case 1: {
                bl = JDBCExtensionsKt.queryForExists$default((Connection)conn, (String)"SELECT 1 FROM sqlite_master WHERE TYPE = 'table' AND name = 'ISRAWSCHEMAVERSION'", null, (int)2, null);
                break;
            }
            case 4: {
                bl = JDBCExtensionsKt.queryForExists$default((Connection)conn, (String)("SELECT 1 FROM information_schema.tables WHERE table_name = 'israwschemaversion' AND table_schema = '" + this.SCHEMA_NAME + '\''), null, (int)2, null);
                break;
            }
            case 5: {
                bl = JDBCExtensionsKt.queryForExists$default((Connection)conn, (String)("SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'israwschemaversion' AND TABLE_SCHEMA = '" + this.SCHEMA_NAME + '\''), null, (int)2, null);
                break;
            }
            case 6: {
                bl = JDBCExtensionsKt.queryForExists$default((Connection)conn, (String)("SELECT 1 FROM information_schema.tables WHERE table_name = 'israwschemaversion' AND table_schema = '" + this.SCHEMA_NAME + '\''), null, (int)2, null);
                break;
            }
            default: {
                throw new SQLException("DBMS is not supported");
            }
        }
        boolean schematableExists = bl;
        existingSchemaVersion = schematableExists ? JDBCExtensionsKt.queryForInt$default((Connection)conn, (String)StringsKt.trimIndent((String)("\n                SELECT schemaversion\n                FROM israwschemaversion\n                WHERE status = '" + this.STATUS_READY + "' AND tableset = '" + this.QUEUE_TABLESET_NAME + "'\n                ORDER BY schemaversion DESC\n                ")), null, (int)2, null) : null;
        if (!this.params.getDropExisting()) {
            if (existingSchemaVersion == null) {
                LOGGER.info((Object)("No Informer schema was found. Installing version " + this.SCHEMAVERSION + '.'));
            } else {
                int n2 = this.SCHEMAVERSION;
                if (existingSchemaVersion == n2) {
                    LOGGER.info((Object)("Informer schema version " + this.SCHEMAVERSION + " is already in place. Nothing to do."));
                    return;
                }
                if (existingSchemaVersion > this.SCHEMAVERSION && !this.params.getDropExisting()) {
                    throw new TerminatingException("The existing Informer schema version " + existingSchemaVersion + " is later than the schema version this installer would apply (version " + this.SCHEMAVERSION + ").\nDowngrade is not supported.\nEither apply changes manually, or rerun this tool with the --drop-existing flag to destroy and recreate these tables (LOSING ALL DATA in the process).");
                }
            }
        }
        if (!this.params.getDropExisting()) {
            String schemaInstallationStatus = schematableExists ? JDBCExtensionsKt.queryForString$default((Connection)conn, (String)StringsKt.trimIndent((String)("\n                    SELECT status\n                    FROM israwschemaversion\n                    WHERE schemaversion = " + this.SCHEMAVERSION + " AND tableset = " + this.QUEUE_TABLESET_NAME + "\n                    ")), null, (int)2, null) : null;
            String string = schemaInstallationStatus;
            if (Intrinsics.areEqual(string, (Object)this.STATUS_READY)) {
                LOGGER.info((Object)("Schema version " + this.SCHEMAVERSION + " for " + this.QUEUE_TABLESET_NAME + " table set is already installed. Nothing to do."));
                return;
            }
            if (Intrinsics.areEqual(string, (Object)this.STATUS_FAILED)) {
                if (!this.params.getDropExisting()) {
                    throw new TerminatingException("Previous attempt to upgrade failed. Current state is unknown; Unable to proceed.\nEither apply changes manually, or rerun this tool with the --drop-existing flag to destroy and recreate these tables (LOSING ALL DATA in the process).");
                }
            } else if (string == null) {
                LOGGER.debug((Object)"No schema installation information was found. Proceeding with installation/upgrade.");
            }
            if (schematableExists) {
                this.setSchemaInstallationStatus(conn, this.STATUS_UPGRADING);
            }
        }
        try {
            if (this.params.getDropExisting()) {
                this.dropAllTables(conn, serverType);
                this.createAllTables(conn, serverType);
            } else {
                boolean bl2;
                Integer n3 = existingSchemaVersion;
                if (n3 == null) {
                    bl2 = true;
                } else {
                    n = 0;
                    bl2 = n3 == 0;
                }
                if (bl2) {
                    this.createAllTables(conn, serverType);
                } else {
                    throw new TerminatingException("Existing schema version of " + existingSchemaVersion + " is unrecognized. Unable to proceed.");
                }
            }
            this.setSchemaInstallationStatus(conn, this.STATUS_READY);
        }
        catch (Exception e) {
            try {
                this.setSchemaInstallationStatus(conn, this.STATUS_FAILED);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private final void setSchemaInstallationStatus(Connection conn, String status) {
        int numUpdated = JDBCExtensionsKt.executeUpdate$default((Connection)conn, (String)StringsKt.trimIndent((String)("\n                UPDATE israwschemaversion\n                SET status = '" + status + "', infversion = '6.4.1-rc.2'\n                WHERE schemaversion = " + this.SCHEMAVERSION + " AND tableset = '" + this.QUEUE_TABLESET_NAME + "'\n                ")), null, (int)2, null);
        if (numUpdated < 1) {
            JDBCExtensionsKt.executeUpdate$default((Connection)conn, (String)StringsKt.trimIndent((String)("\n                INSERT INTO israwschemaversion (schemaversion, tableset, infversion, status)\n                VALUES (" + this.SCHEMAVERSION + ", '" + this.QUEUE_TABLESET_NAME + "', '6.4.1-rc.2', '" + status + "')\n                ")), null, (int)2, null);
        }
    }

    private final void createAllTables(Connection conn, DbServerType dbServerType) {
        switch (WhenMappings.$EnumSwitchMapping$0[dbServerType.ordinal()]) {
            case 2: {
                this.runScript(conn, dbServerType, "mastertables_oracle.sql");
                this.runScript(conn, dbServerType, "catalogqueue_oracle.sql");
                this.runScript(conn, dbServerType, "notificationqueue_oracle.sql");
                this.runScript(conn, dbServerType, "pushqueue_oracle.sql");
                this.runScript(conn, dbServerType, "queuemonitor_oracle.sql");
                break;
            }
            case 1: {
                this.runScript(conn, dbServerType, "mastertables_sqlite.sql");
                this.runScript(conn, dbServerType, "catalogqueue_sqlite.sql");
                this.runScript(conn, dbServerType, "notificationqueue_sqlite.sql");
                this.runScript(conn, dbServerType, "pushqueue_sqlite.sql");
                this.runScript(conn, dbServerType, "queuemonitor_sqlite.sql");
                break;
            }
            case 3: {
                this.runScript(conn, dbServerType, "mastertables_db2.sql");
                this.runScript(conn, dbServerType, "catalogqueue_db2.sql");
                this.runScript(conn, dbServerType, "notificationqueue_db2.sql");
                this.runScript(conn, dbServerType, "pushqueue_db2.sql");
                this.runScript(conn, dbServerType, "queuemonitor_db2.sql");
                break;
            }
            case 4: {
                this.runScript(conn, dbServerType, "mastertables_mysql.sql");
                this.runScript(conn, dbServerType, "catalogqueue_mysql.sql");
                this.runScript(conn, dbServerType, "notificationqueue_mysql.sql");
                this.runScript(conn, dbServerType, "pushqueue_mysql.sql");
                this.runScript(conn, dbServerType, "queuemonitor_mysql.sql");
                break;
            }
            case 5: {
                this.runScript(conn, dbServerType, "mastertables_mssql.sql");
                this.runScript(conn, dbServerType, "catalogqueue_mssql.sql");
                this.runScript(conn, dbServerType, "notificationqueue_mssql.sql");
                this.runScript(conn, dbServerType, "pushqueue_mssql.sql");
                this.runScript(conn, dbServerType, "queuemonitor_mssql.sql");
                break;
            }
            case 6: {
                this.runScript(conn, dbServerType, "mastertables_postgresql.sql");
                this.runScript(conn, dbServerType, "catalogqueue_postgresql.sql");
                this.runScript(conn, dbServerType, "notificationqueue_postgresql.sql");
                this.runScript(conn, dbServerType, "pushqueue_postgresql.sql");
                this.runScript(conn, dbServerType, "queuemonitor_postgresql.sql");
                break;
            }
            default: {
                throw new TerminatingException("Database of type " + dbServerType + " does not have defined table creation scripts, and must be configured manually.");
            }
        }
    }

    private final void dropAllTables(Connection conn, DbServerType dbServerType) {
        switch (WhenMappings.$EnumSwitchMapping$0[dbServerType.ordinal()]) {
            case 2: {
                this.runScript(conn, dbServerType, "droptables_oracle.sql");
                break;
            }
            case 1: {
                this.runScript(conn, dbServerType, "droptables_sqlite.sql");
                break;
            }
            case 3: {
                this.runScript(conn, dbServerType, "droptables_db2.sql");
                break;
            }
            case 4: {
                this.runScript(conn, dbServerType, "droptables_mysql.sql");
                break;
            }
            case 5: {
                this.runScript(conn, dbServerType, "droptables_mssql.sql");
                break;
            }
            case 6: {
                this.runScript(conn, dbServerType, "droptables_postgresql.sql");
                break;
            }
            default: {
                throw new TerminatingException("Database of type " + dbServerType + " does not have defined table drop scripts, and must be configured manually.");
            }
        }
    }

    private final void runScript(Connection conn, DbServerType dbServerType, String scriptName) throws SQLException, IOException {
        this.useScript(scriptName, (Function1)new Function1<Reader, Unit>(conn, dbServerType, this){
            final /* synthetic */ Connection $conn;
            final /* synthetic */ DbServerType $dbServerType;
            final /* synthetic */ InformerDbSetup this$0;
            {
                this.$conn = $conn;
                this.$dbServerType = $dbServerType;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Reader scriptReader) {
                Intrinsics.checkNotNullParameter((Object)scriptReader, (String)"scriptReader");
                new ScriptRunner(this.$conn, this.$dbServerType, Log4jAdapterKt.toGenericLogger((Logger)InformerDbSetup.Companion.getLOGGER()), this.this$0.getParams().getAbortOnWarning()).runScript(scriptReader);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> void useScript(String scriptName, Function1<? super Reader, ? extends R> block) throws SQLException, IOException {
        Object object;
        URL uRL = ClassLoader.getSystemResource("informer/scripts/" + scriptName);
        if (uRL == null && (uRL = ClassLoader.getSystemResource("scripts/" + scriptName)) == null) {
            uRL = ClassLoader.getSystemResource(scriptName);
        }
        if ((object = uRL) == null) {
            throw new IOException("Resource not found: " + scriptName);
        }
        URL resource = object;
        LOGGER.info((Object)("Running script file found at " + resource));
        InputStream inputStream = resource.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resource.openStream()");
        object = inputStream;
        Object object2 = Charsets.UTF_8;
        Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
        int n = 8192;
        object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        object2 = null;
        try {
            object3 = block.invoke(object);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        Logger logger = LogManager.getLogger(InformerDbSetup.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001bB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params;", "", "jdbcURL", "", "userInfo", "Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params$UserCreds;", "dropExisting", "", "abortOnWarning", "(Ljava/lang/String;Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params$UserCreds;ZZ)V", "getAbortOnWarning", "()Z", "getDropExisting", "getJdbcURL", "()Ljava/lang/String;", "getUserInfo", "()Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params$UserCreds;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "UserCreds", "isinformer-tools"})
    public static final class Params {
        @NotNull
        private final String jdbcURL;
        @Nullable
        private final UserCreds userInfo;
        private final boolean dropExisting;
        private final boolean abortOnWarning;

        public Params(@NotNull String jdbcURL, @Nullable UserCreds userInfo, boolean dropExisting, boolean abortOnWarning) {
            Intrinsics.checkNotNullParameter((Object)jdbcURL, (String)"jdbcURL");
            this.jdbcURL = jdbcURL;
            this.userInfo = userInfo;
            this.dropExisting = dropExisting;
            this.abortOnWarning = abortOnWarning;
        }

        public /* synthetic */ Params(String string, UserCreds userCreds, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            this(string, userCreds, bl, bl2);
        }

        @NotNull
        public final String getJdbcURL() {
            return this.jdbcURL;
        }

        @Nullable
        public final UserCreds getUserInfo() {
            return this.userInfo;
        }

        public final boolean getDropExisting() {
            return this.dropExisting;
        }

        public final boolean getAbortOnWarning() {
            return this.abortOnWarning;
        }

        @NotNull
        public final String component1() {
            return this.jdbcURL;
        }

        @Nullable
        public final UserCreds component2() {
            return this.userInfo;
        }

        public final boolean component3() {
            return this.dropExisting;
        }

        public final boolean component4() {
            return this.abortOnWarning;
        }

        @NotNull
        public final Params copy(@NotNull String jdbcURL, @Nullable UserCreds userInfo, boolean dropExisting, boolean abortOnWarning) {
            Intrinsics.checkNotNullParameter((Object)jdbcURL, (String)"jdbcURL");
            return new Params(jdbcURL, userInfo, dropExisting, abortOnWarning);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, UserCreds userCreds, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.jdbcURL;
            }
            if ((n & 2) != 0) {
                userCreds = params.userInfo;
            }
            if ((n & 4) != 0) {
                bl = params.dropExisting;
            }
            if ((n & 8) != 0) {
                bl2 = params.abortOnWarning;
            }
            return params.copy(string, userCreds, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Params(jdbcURL=" + this.jdbcURL + ", userInfo=" + this.userInfo + ", dropExisting=" + this.dropExisting + ", abortOnWarning=" + this.abortOnWarning + ')';
        }

        public int hashCode() {
            int result = this.jdbcURL.hashCode();
            result = result * 31 + (this.userInfo == null ? 0 : this.userInfo.hashCode());
            int n = this.dropExisting ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.abortOnWarning ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.jdbcURL, (Object)params.jdbcURL)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userInfo, (Object)params.userInfo)) {
                return false;
            }
            if (this.dropExisting != params.dropExisting) {
                return false;
            }
            return this.abortOnWarning == params.abortOnWarning;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Params$UserCreds;", "", "username", "", "userPassword", "(Ljava/lang/String;Ljava/lang/String;)V", "getUserPassword", "()Ljava/lang/String;", "getUsername", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "isinformer-tools"})
        public static final class UserCreds {
            @NotNull
            private final String username;
            @Nullable
            private final String userPassword;

            public UserCreds(@NotNull String username, @Nullable String userPassword) {
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                this.username = username;
                this.userPassword = userPassword;
            }

            @NotNull
            public final String getUsername() {
                return this.username;
            }

            @Nullable
            public final String getUserPassword() {
                return this.userPassword;
            }

            @NotNull
            public final String component1() {
                return this.username;
            }

            @Nullable
            public final String component2() {
                return this.userPassword;
            }

            @NotNull
            public final UserCreds copy(@NotNull String username, @Nullable String userPassword) {
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                return new UserCreds(username, userPassword);
            }

            public static /* synthetic */ UserCreds copy$default(UserCreds userCreds, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = userCreds.username;
                }
                if ((n & 2) != 0) {
                    string2 = userCreds.userPassword;
                }
                return userCreds.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "UserCreds(username=" + this.username + ", userPassword=" + this.userPassword + ')';
            }

            public int hashCode() {
                int result = this.username.hashCode();
                result = result * 31 + (this.userPassword == null ? 0 : this.userPassword.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UserCreds)) {
                    return false;
                }
                UserCreds userCreds = (UserCreds)other;
                if (!Intrinsics.areEqual((Object)this.username, (Object)userCreds.username)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.userPassword, (Object)userCreds.userPassword);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/interlocsolutions/maximo/tools/InformerDbSetup$TerminatingException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "isinformer-tools"})
    public static final class TerminatingException
    extends Exception {
        public TerminatingException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/interlocsolutions/maximo/tools/InformerDbSetup$Companion;", "", "()V", "LOGGER", "Lorg/apache/log4j/Logger;", "getLOGGER", "()Lorg/apache/log4j/Logger;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "promptForBoolean", "", "msg", "defaultValue", "(Ljava/lang/String;Ljava/lang/Boolean;)Z", "promptForPassword", "promptForString", "isinformer-tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            URL uRL;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Companion it = this;
            boolean bl = false;
            String log4jConfigFileName = "log4j_informer_dbtool.xml";
            URL uRL2 = ClassLoader.getSystemResource("informer/" + log4jConfigFileName);
            if (uRL2 == null) {
                uRL2 = ClassLoader.getSystemResource(log4jConfigFileName);
            }
            if ((uRL = uRL2) == null) {
                throw new IOException("Resource not found: " + log4jConfigFileName);
            }
            DOMConfigurator.configure((URL)uRL);
            try {
                String $this$main_u24lambda_u247_u24lambda_u246;
                UnflaggedOption $this$main_u24lambda_u247_u24lambda_u245;
                UnflaggedOption $this$main_u24lambda_u247_u24lambda_u244;
                UnflaggedOption $this$main_u24lambda_u247_u24lambda_u243;
                UnflaggedOption $this$main_u24lambda_u247_u24lambda_u242;
                UnflaggedOption $this$main_u24lambda_u247_u24lambda_u241;
                UnflaggedOption unflaggedOption;
                JSAP jSAP;
                String paramJdbcURL = "jdbcURL";
                String paramDbUser = "dbuser";
                String paramDbPass = "dbpass";
                String paramDropExisting = "drop-existing";
                String paramSurviveWarnings = "survive-warnings";
                String paramHelp = "help";
                JSAP $this$main_u24lambda_u247 = jSAP = new JSAP();
                boolean bl2 = false;
                UnflaggedOption unflaggedOption2 = unflaggedOption = new UnflaggedOption(paramJdbcURL);
                JSAP jSAP2 = $this$main_u24lambda_u247;
                boolean bl3 = false;
                $this$main_u24lambda_u247_u24lambda_u241.setStringParser((StringParser)JSAP.STRING_PARSER);
                $this$main_u24lambda_u247_u24lambda_u241.setRequired(true);
                $this$main_u24lambda_u247_u24lambda_u241.setGreedy(false);
                $this$main_u24lambda_u247_u24lambda_u241.setHelp("The connection string to reach the database");
                jSAP2.registerParameter((Parameter)unflaggedOption);
                $this$main_u24lambda_u247_u24lambda_u241 = unflaggedOption = new FlaggedOption(paramDbUser);
                jSAP2 = $this$main_u24lambda_u247;
                boolean bl4 = false;
                $this$main_u24lambda_u247_u24lambda_u242.setStringParser((StringParser)JSAP.STRING_PARSER);
                $this$main_u24lambda_u247_u24lambda_u242.setRequired(false);
                $this$main_u24lambda_u247_u24lambda_u242.setShortFlag('u');
                $this$main_u24lambda_u247_u24lambda_u242.setLongFlag("username");
                $this$main_u24lambda_u247_u24lambda_u242.setHelp("Database username to access the resource specified via the JDBC URL.\nIf a password parameter is not also provided, you will be prompted.");
                jSAP2.registerParameter((Parameter)unflaggedOption);
                $this$main_u24lambda_u247_u24lambda_u242 = unflaggedOption = new FlaggedOption(paramDbPass);
                jSAP2 = $this$main_u24lambda_u247;
                boolean bl5 = false;
                $this$main_u24lambda_u247_u24lambda_u243.setStringParser((StringParser)JSAP.STRING_PARSER);
                $this$main_u24lambda_u247_u24lambda_u243.setRequired(false);
                $this$main_u24lambda_u247_u24lambda_u243.setShortFlag('p');
                $this$main_u24lambda_u247_u24lambda_u243.setLongFlag("password");
                $this$main_u24lambda_u247_u24lambda_u243.setHelp("Database passsword for the specified username.\nUseful only when combined with the --user option.\nIf unspecified, you will be prompted.");
                jSAP2.registerParameter((Parameter)unflaggedOption);
                $this$main_u24lambda_u247_u24lambda_u243 = unflaggedOption = new Switch(paramDropExisting);
                jSAP2 = $this$main_u24lambda_u247;
                boolean bl6 = false;
                $this$main_u24lambda_u247_u24lambda_u244.setLongFlag("drop-existing");
                $this$main_u24lambda_u247_u24lambda_u244.setHelp("Indicates that existing tables should be dropped, and a new schema created from scratch.");
                jSAP2.registerParameter((Parameter)unflaggedOption);
                $this$main_u24lambda_u247_u24lambda_u244 = unflaggedOption = new Switch(paramSurviveWarnings);
                jSAP2 = $this$main_u24lambda_u247;
                boolean bl7 = false;
                $this$main_u24lambda_u247_u24lambda_u245.setLongFlag("survive-warnings");
                $this$main_u24lambda_u247_u24lambda_u245.setHelp("Should the database return a non-fatal 'warning' message, this flag indicates that\nthe user wishes the process to continue. The warning will still be reported in the log,\nwhich should always be reviewed.");
                jSAP2.registerParameter((Parameter)unflaggedOption);
                $this$main_u24lambda_u247_u24lambda_u245 = unflaggedOption = new Switch(paramHelp);
                jSAP2 = $this$main_u24lambda_u247;
                boolean bl8 = false;
                $this$main_u24lambda_u247_u24lambda_u246.setShortFlag('h');
                $this$main_u24lambda_u247_u24lambda_u246.setLongFlag("help");
                $this$main_u24lambda_u247_u24lambda_u246.setHelp("Print this help information.");
                jSAP2.registerParameter((Parameter)unflaggedOption);
                JSAP jsap = jSAP;
                try {
                    Params.UserCreds userCreds;
                    InformerDbSetup executable = null;
                    JSAPResult parsedArgs = jsap.parse(args);
                    boolean bl9 = false;
                    if (parsedArgs.getBoolean("help")) {
                        System.out.println((Object)jsap.getHelp());
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                    String string = $this$main_u24lambda_u247_u24lambda_u246 = parsedArgs.getString(paramDbUser);
                    if (string != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(paramDbUser)");
                        String dbUserName = $this$main_u24lambda_u247_u24lambda_u246;
                        boolean bl10 = false;
                        String dbPassword = parsedArgs.getString(paramDbPass);
                        while (true) {
                            boolean bl11;
                            String string2;
                            String string3 = string2 = dbPassword;
                            if (string3 != null) {
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dbPassword");
                                bl11 = !StringsKt.isBlank((CharSequence)string2);
                            } else {
                                bl11 = false;
                            }
                            if (bl11) break;
                            dbPassword = Companion.promptForPassword("Enter password for User " + dbUserName);
                        }
                        userCreds = new Params.UserCreds(dbUserName, dbPassword);
                    } else {
                        userCreds = null;
                    }
                    Params.UserCreds userInfo = userCreds;
                    String string4 = parsedArgs.getString(paramJdbcURL);
                    boolean bl12 = parsedArgs.getBoolean(paramDropExisting, false);
                    boolean bl13 = !parsedArgs.getBoolean(paramSurviveWarnings, false);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(paramJdbcURL)");
                    Params params = new Params(string4, userInfo, bl12, bl13);
                    executable = new InformerDbSetup(params);
                    executable.execute();
                }
                catch (IllegalStateException e) {
                    System.err.println(jsap.getHelp());
                    throw e;
                }
            }
            catch (SQLWarning e) {
                this.getLOGGER().error((Object)StringsKt.trimIndent((String)("\n                    Execution is terminating due to a SQLWarning:\n                    " + e.getMessage() + "\n                    The log may contain further detail about the statement being executed when the warning occurred.\n                    The --survive-warnings flag can be used to treat such warning messages as non-fatal.\n                    ")));
                System.exit(-1);
            }
            catch (TerminatingException e) {
                this.getLOGGER().error((Object)("Fatal error: " + e));
                System.exit(-1);
            }
            catch (Exception e) {
                this.getLOGGER().debug((Object)("Fatal error: " + e), (Throwable)e);
                this.getLOGGER().error((Object)("Fatal error: " + e));
                System.exit(-1);
            }
        }

        private final String promptForString(String msg, String defaultValue) {
            while (true) {
                if (defaultValue == null) {
                    System.out.println((Object)msg);
                } else {
                    System.out.println((Object)(msg + " [" + defaultValue + ']'));
                }
                String string = ConsoleKt.readLine();
                String responseValue = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                String string2 = responseValue;
                boolean bl = string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false;
                if (bl) {
                    return responseValue;
                }
                String string3 = defaultValue;
                if (string3 == null) continue;
                return string3;
            }
        }

        private final String promptForPassword(String msg) {
            Console console = System.console();
            String response = null;
            while (true) {
                String string;
                String string2 = response;
                if (string2 != null ? ((CharSequence)string2).length() > 0 : false) break;
                if (console != null) {
                    if (console.readPassword(msg + ": ", new Object[0]) != null) {
                        char[] it;
                        boolean bl = false;
                        string = new String(it);
                    } else {
                        string = null;
                    }
                } else {
                    System.out.println((Object)(msg + ": "));
                    System.out.println((Object)"(Warning: A Console reference could not be obtained, so your password will appear in plaintext)");
                    String string3 = ConsoleKt.readLine();
                    string = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
                }
                response = string;
            }
            return response;
        }

        /*
         * Unable to fully structure code
         */
        private final boolean promptForBoolean(String msg, Boolean defaultValue) {
            block14: while (true) {
                if ((var3_3 = defaultValue) == null) {
                    System.out.println((Object)(msg + " [y/n]"));
                } else if (Intrinsics.areEqual((Object)var3_3, (Object)true)) {
                    System.out.println((Object)(msg + " [Y/n]"));
                } else if (Intrinsics.areEqual((Object)var3_3, (Object)false)) {
                    System.out.println((Object)(msg + " [y/N]"));
                }
                if ((v0 = ConsoleKt.readLine()) != null && (v0 = StringsKt.trim((CharSequence)v0).toString()) != null) {
                    v1 = v0.toLowerCase();
                    v2 = v1;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).toLowerCase()");
                } else {
                    v2 = var3_3 = null;
                }
                if (var3_3 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var3_3.hashCode()) {
                    case 0: {
                        if (var3_3.equals("")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 3521: {
                        if (var3_3.equals("no")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 119527: {
                        if (var3_3.equals("yes")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 121: {
                        if (var3_3.equals("y")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case 110: {
                        if (var3_3.equals("n")) {
                            tmp = 5;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: lbl-1000:
                    // 2 sources

                    {
                        v3 = defaultValue;
                        if (v3 != null) {
                            return v3;
                        }
                        continue block14;
                    }
                    case 4: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                    case 5: {
                        return false;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DbServerType.values().length];
            try {
                nArray[DbServerType.SQLITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbServerType.ORACLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbServerType.DB2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbServerType.MYSQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbServerType.MSSQL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbServerType.POSTGRESQL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

