/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.servlet;

import com.interlocsolutions.maximo.notify.NotifyRemote;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.webclient.servlet.AppDeployUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXException;

public class NotifyServlet
extends HttpServlet {
    private static final long serialVersionUID = -1313224690951236796L;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        MboSetRemote notifySet = null;
        MboSetRemote logSet = null;
        try {
            String path = req.getServletPath();
            String reqPath = req.getRequestURL().toString();
            path = reqPath.substring(reqPath.indexOf(path) + path.length());
            if (path != null) {
                byte[] data;
                String id;
                String[] pathSeg = path.split("/");
                boolean deploy = false;
                boolean isLog = false;
                boolean isScreenshot = false;
                boolean isResource = false;
                boolean isJar = false;
                String app = null;
                for (String seg : pathSeg) {
                    if (seg.equals("appdeploy")) {
                        deploy = true;
                        continue;
                    }
                    if (deploy && app == null) {
                        app = seg;
                        break;
                    }
                    if (!deploy && seg.equals("log")) {
                        isLog = true;
                        continue;
                    }
                    if (!deploy && seg.equals("screenshot")) {
                        isScreenshot = true;
                        continue;
                    }
                    if (!deploy && seg.equals("resource")) {
                        isResource = true;
                        continue;
                    }
                    if (deploy || !seg.equals("jar")) continue;
                    isJar = true;
                }
                if (deploy) {
                    AppDeployUtil.handleAppDeloy(req, resp, app);
                    NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                    NotifyUtil.closeAndCleanup(logSet);
                    return;
                }
                if (isLog) {
                    id = req.getParameter("id");
                    if (id != null) {
                        logSet = MXServer.getMXServer().getMboSet("ISDEVICELOG", MXServer.getMXServer().getSystemUserInfo());
                        MboRemote log = logSet.getMboForUniqueId(Long.valueOf(id).longValue());
                        if (log != null) {
                            resp.setContentType("text/plain");
                            String data2 = log.getString("LOG");
                            resp.setHeader("Content-Disposition", "attachment; " + log.getString("DEVICE.NAME") + ".log");
                            resp.setContentLength(data2.length());
                            resp.getWriter().write(data2);
                        }
                        NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                        NotifyUtil.closeAndCleanup((MboSetRemote)logSet);
                        return;
                    }
                } else if (isScreenshot) {
                    id = req.getParameter("id");
                    if (id != null) {
                        logSet = MXServer.getMXServer().getMboSet("ISDEVICELOG", MXServer.getMXServer().getSystemUserInfo());
                        MboRemote log = logSet.getMboForUniqueId(Long.valueOf(id).longValue());
                        if (log != null) {
                            resp.setContentType("image/jpeg");
                            String sdata = log.getString("LOG");
                            data = Base64.decodeBase64((String)sdata);
                            resp.setContentLength(data.length);
                            resp.getOutputStream().write(data);
                        }
                        NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                        NotifyUtil.closeAndCleanup((MboSetRemote)logSet);
                        return;
                    }
                } else if (isResource) {
                    id = req.getParameter("id");
                    if (id != null) {
                        MboSetRemote resourceSet = MXServer.getMXServer().getMboSet("ISNOTIFYRESOURCE", MXServer.getMXServer().getSystemUserInfo());
                        MboRemote resource = resourceSet.getMboForUniqueId(Long.parseLong(id));
                        if (resource != null) {
                            resp.setContentType("application/octet-stream");
                            String sData = resource.getString("DATA");
                            byte[] data3 = Base64.decodeBase64((String)sData);
                            resp.setContentLength(data3.length);
                            resp.getOutputStream().write(data3);
                        }
                        NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                        NotifyUtil.closeAndCleanup((MboSetRemote)logSet);
                        return;
                    }
                } else if (isJar && (id = req.getParameter("id")) != null) {
                    MboSetRemote resourceSet = MXServer.getMXServer().getMboSet("ISNOTIFYJARS", MXServer.getMXServer().getSystemUserInfo());
                    MboRemote resource = resourceSet.getMboForUniqueId(Long.parseLong(id));
                    if (resource != null) {
                        resp.setContentType("application/octet-stream");
                        resp.setHeader("Content-Disposition", "attachment; filename=\"" + resource.getString("NAME") + "\"");
                        data = resource.getBytes("DATA");
                        resp.setContentLength(data.length);
                        resp.getOutputStream().write(data);
                    }
                    NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                    NotifyUtil.closeAndCleanup((MboSetRemote)logSet);
                    return;
                }
            }
            resp.setContentType("text/xml");
            String id = req.getParameter("id");
            if (id == null) {
                throw new ServletException("No id specified.");
            }
            notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
            NotifyRemote notify = (NotifyRemote)notifySet.getMboForUniqueId(Long.valueOf(id).longValue());
            if (notify == null) {
                throw new ServletException("No notification found for the specified id");
            }
            resp.setHeader("Content-Disposition", "attachment; filename=" + notify.getString("NOTIFYNUM") + ".xml");
            String val = notify.export();
            resp.setContentLength(val.length());
            resp.getWriter().write(val);
            NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
        }
        catch (IOException e) {
            try {
                resp.getWriter().print(e.getMessage());
                return;
            }
            catch (IOException e1) {
                throw new ServletException((Throwable)e);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (MXException e2) {
                try {
                    resp.getWriter().print(e2.getMessage());
                    return;
                }
                catch (IOException e1) {
                    throw new ServletException((Throwable)e2);
                }
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(notifySet);
            NotifyUtil.closeAndCleanup(logSet);
        }
        NotifyUtil.closeAndCleanup((MboSetRemote)logSet);
        return;
    }

    public static enum PlatformType {
        ANDROID,
        IOS,
        WINDOWS,
        UNKNOWN,
        MACINTOSH;

    }
}

