/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.servlet;

import com.interlocsolutions.maximo.notify.util.IOUtils;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.velocity.VelocityMboSet;
import com.interlocsolutions.maximo.notify.xml.PListManifest;
import com.interlocsolutions.maximo.webclient.servlet.NotifyServlet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.util.MXException;

public class AppDeployUtil {
    private static final String VELOCITY_LOG_TAG = "informer";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void handleAppDeloy(HttpServletRequest req, HttpServletResponse resp, String app) throws ServletException {
        MboSetRemote deploySet;
        MboSetRemote notifySet;
        block24: {
            MboRemote deploy;
            SqlFormat sqlf;
            String type;
            block28: {
                block27: {
                    boolean isIOSApp;
                    block26: {
                        block25: {
                            boolean isPlist;
                            block23: {
                                notifySet = null;
                                deploySet = null;
                                type = req.getParameter("platform");
                                isPlist = req.getRequestURI().toLowerCase().endsWith("app.plist");
                                isIOSApp = req.getRequestURI().toLowerCase().endsWith(".ipa");
                                boolean isProfile = "profile".equals(req.getParameter("data"));
                                if (isPlist || isIOSApp || isProfile) {
                                    type = "IOS";
                                }
                                NotifyServlet.PlatformType platform = AppDeployUtil.getPlatform(req);
                                if (type == null) {
                                    if (platform == NotifyServlet.PlatformType.IOS) {
                                        type = "IOS";
                                    } else if (platform == NotifyServlet.PlatformType.ANDROID) {
                                        type = "ANDROID";
                                    } else {
                                        String string;
                                        if (platform != null) {
                                            string = platform.toString();
                                            throw new ServletException(string);
                                        }
                                        string = "Unknown is not a supported platform";
                                        throw new ServletException(string);
                                    }
                                }
                                if (app == null || !isIOSApp && !"app".equals(req.getParameter("data")) || !PropUtils.getBooleanMaxProp((String)"informer.deploy.streamapp", (boolean)false)) break block23;
                                AppDeployUtil.streamApplication(resp, app, type);
                                NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                                NotifyUtil.closeAndCleanup(deploySet);
                                return;
                            }
                            notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
                            if (app == null) {
                                ArrayList<Long> ids = new ArrayList<Long>();
                                MboRemote notify = notifySet.moveFirst();
                                while (notify != null) {
                                    MboSetRemote appSet = notify.getMboSet("APPDEPLOY");
                                    SqlFormat sqlf2 = new SqlFormat("type = :1 and active = :yes");
                                    sqlf2.setObject(1, "ISAPPDEPLOY", "TYPE", type);
                                    appSet.setWhere(sqlf2.format());
                                    appSet.setOrderBy("version desc");
                                    appSet.reset();
                                    if (!appSet.isEmpty()) {
                                        ids.add(appSet.getMbo(0).getUniqueIDValue());
                                    }
                                    notify = notifySet.moveNext();
                                }
                                deploySet = MXServer.getMXServer().getMboSet("ISAPPDEPLOY", MXServer.getMXServer().getSystemUserInfo());
                                while (deploySet.moveNext() != null) {
                                    long id = deploySet.getMbo().getUniqueIDValue();
                                    if (ids.contains(id)) continue;
                                    deploySet.remove();
                                }
                                AppDeployUtil.getAppPage(req, resp, deploySet, type);
                                break block24;
                            }
                            sqlf = new SqlFormat("notifynum = :1");
                            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", app);
                            notifySet.setWhere(sqlf.format());
                            if (notifySet.isEmpty()) {
                                throw new ServletException("The profile " + app + " does not exist.");
                            }
                            MboRemote notify = notifySet.getMbo(0);
                            sqlf = new SqlFormat("type = :1 and active = :yes");
                            sqlf.setObject(1, "ISAPPDEPLOY", "TYPE", type);
                            deploySet = notify.getMboSet("APPDEPLOY");
                            deploySet.setWhere(sqlf.format());
                            deploySet.setOrderBy("version desc");
                            if (deploySet.isEmpty()) {
                                throw new ServletException("No active applications were found for the " + app + " profile on the " + type + " platform.");
                            }
                            deploy = deploySet.getMbo(0);
                            if (!isPlist) break block25;
                            AppDeployUtil.getPlist(req, resp, deploy, type);
                            NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                            NotifyUtil.closeAndCleanup((MboSetRemote)deploySet);
                            return;
                        }
                        if (!"icon".equals(req.getParameter("data"))) break block26;
                        AppDeployUtil.getApplicationImage(req, resp, deploy);
                        NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                        NotifyUtil.closeAndCleanup((MboSetRemote)deploySet);
                        return;
                    }
                    if (!isIOSApp && !"app".equals(req.getParameter("data"))) break block27;
                    AppDeployUtil.getApplication(req, resp, deploy);
                    NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                    NotifyUtil.closeAndCleanup((MboSetRemote)deploySet);
                    return;
                }
                if (!type.equals("IOS") || !"profile".equals(req.getParameter("data"))) break block28;
                AppDeployUtil.getMobileProfile(req, resp, deploy);
                NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
                NotifyUtil.closeAndCleanup((MboSetRemote)deploySet);
                return;
            }
            try {
                sqlf = new SqlFormat(deploy.getUniqueIDName() + " = :1");
                sqlf.setLong(1, deploy.getUniqueIDValue());
                deploySet.setWhere(sqlf.format());
                deploySet.reset();
                AppDeployUtil.getAppPage(req, resp, deploySet, type);
            }
            catch (ServletException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new ServletException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(notifySet);
                    NotifyUtil.closeAndCleanup(deploySet);
                    throw throwable;
                }
            }
        }
        NotifyUtil.closeAndCleanup((MboSetRemote)notifySet);
        NotifyUtil.closeAndCleanup((MboSetRemote)deploySet);
        return;
    }

    public static void getMobileProfile(HttpServletRequest req, HttpServletResponse resp, MboRemote deploy) throws MXException, IOException {
        byte[] data = deploy.getBytes("PROVISIONPROFILE");
        resp.setContentLength(data.length);
        resp.setContentType("application/octet-stream");
        String name = deploy.getString("NAME");
        name = name.contains(".") ? name.substring(0, name.indexOf(".")) + ".mobileprovision" : name + ".mobileprovision";
        resp.setHeader("Content-Disposition", "attachment; filename=" + name);
        resp.getOutputStream().write(data);
        resp.getOutputStream().close();
    }

    public static void getApplication(HttpServletRequest req, HttpServletResponse resp, MboRemote deploy) throws MXException, IOException {
        byte[] data = Base64.decodeBase64((String)deploy.getString("APPLICATION"));
        resp.setContentLength(data.length);
        resp.setContentType("application/octet-stream");
        resp.setHeader("Content-Disposition", "attachment; filename=" + (deploy.isNull("FILENAME") ? "application.ipa" : deploy.getString("FILENAME")));
        resp.setHeader("Content-Transfer-Encoding", "binary");
        resp.getOutputStream().write(data);
        resp.getOutputStream().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamApplication(HttpServletResponse resp, String app, String type) throws MXException, IOException, ServletException {
        MXServer mxServer = MXServer.getMXServer();
        DBManager dbManager = mxServer.getDBManager();
        ConnectionKey connKey = dbManager.getSystemConnectionKey();
        Connection conn = dbManager.getConnection(connKey);
        try (Statement statement = conn.createStatement();){
            SqlFormat sqlf = new SqlFormat("SELECT application, filename FROM isappdeploy WHERE active = 1 AND type = :1 AND notifyid = (SELECT notifyid FROM isnotify WHERE notifynum = :2) ORDER BY version DESC");
            sqlf.setObject(1, "ISAPPDEPLOY", "TYPE", type);
            sqlf.setObject(2, "ISNOTIFY", "NOTIFYNUM", app);
            ResultSet resultSet = statement.executeQuery(sqlf.format());
            boolean hasResult = resultSet.next();
            if (!hasResult) {
                throw new ServletException(String.format("No active applications were found for the %s Profile on the %s platform.", app, type));
            }
            String fileName = resultSet.getString("filename");
            if (StringUtils.isEmpty((String)fileName)) {
                fileName = "application.ipa";
            }
            resp.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            resp.setHeader("Content-Transfer-Encoding", "binary");
            resp.setContentType("application/octet-stream");
            try (InputStream encodedAppStream = resultSet.getAsciiStream("application");){
                Base64InputStream decodedInputStream = new Base64InputStream(encodedAppStream, false);
                try (ServletOutputStream netResponseStream = resp.getOutputStream();){
                    IOUtils.streamCopy((InputStream)decodedInputStream, (OutputStream)netResponseStream, (int)1024);
                }
            }
        }
        catch (SQLException e) {
            throw new ServletException("Error serving application for the " + app + " profile on the " + type + " platform.");
        }
        finally {
            dbManager.freeConnection(connKey);
        }
    }

    public static void getPlist(HttpServletRequest req, HttpServletResponse resp, MboRemote deploy, String type) throws MXException, IOException {
        PListManifest plist = new PListManifest();
        plist.setBundle(deploy.getString("BUNDLE"));
        plist.setSubtitle(deploy.getString("DESCRIPTION"));
        plist.setTitle(deploy.getString("TITLE"));
        String host = MXServer.getMXServer().getProperty("informer.system.deploy.url");
        if (host == null || host.trim().length() == 0) {
            host = req.getRequestURL().toString();
        }
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        if (!(host = host.toLowerCase()).endsWith(deploy.getString("NOTIFY.NOTIFYNUM").toLowerCase() + "/")) {
            host = host + deploy.getString("NOTIFY.NOTIFYNUM").toLowerCase() + "/";
        }
        host = "IOS".equals(type) ? host + (deploy.isNull("FILENAME") ? "application.ipa" : deploy.getString("FILENAME").replace(" ", "%20")) : host + "?data=app&platform=" + type;
        plist.setUrl(host);
        plist.setVersion(deploy.getString("VERSIONNAME"));
        String xml = plist.getXml();
        resp.setContentLength(xml.length());
        resp.getWriter().write(xml);
        resp.setContentType("text/xml");
        resp.setHeader("Content-Disposition", "inline; filename=manifest.plist");
        resp.getWriter().close();
    }

    public static void getAppPage(HttpServletRequest req, HttpServletResponse resp, MboSetRemote deploySet, String type) throws MXException, IOException {
        resp.setContentType("text/html; charset=utf-8");
        resp.setHeader("Content-Disposition", "");
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        VelocityContext vc = new VelocityContext();
        boolean isSingle = !req.getRequestURI().endsWith("appdeploy") && !req.getRequestURI().endsWith("appdeploy/");
        vc.put("set", (Object)new VelocityMboSet(deploySet));
        vc.put("platform", (Object)type);
        vc.put("issingle", (Object)isSingle);
        String host = MXServer.getMXServer().getProperty("informer.system.deploy.url");
        if (host == null || host.trim().length() == 0) {
            host = req.getRequestURL().toString();
        } else {
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            if (isSingle) {
                String path = req.getServletPath();
                String reqPath = req.getRequestURL().toString();
                path = reqPath.substring(reqPath.indexOf(path) + path.length());
                String[] pathSeg = path.split("/");
                String app = null;
                for (String seg : pathSeg) {
                    if ((seg = seg.trim()).equals(VELOCITY_LOG_TAG) || seg.equals("apps") || seg.length() <= 0) continue;
                    app = seg;
                    break;
                }
                host = host + app + "/";
            }
        }
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        host = host.toLowerCase();
        vc.put("url", (Object)host);
        try {
            String line = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(AppDeployUtil.class.getResourceAsStream("/informer/appdeploy-" + type.toLowerCase() + ".html")));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            ve.evaluate((Context)vc, (Writer)resp.getWriter(), VELOCITY_LOG_TAG, sb.toString());
        }
        catch (ParseErrorException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
    }

    public static void getApplicationImage(HttpServletRequest req, HttpServletResponse resp, MboRemote deploy) throws MXException, IOException {
        byte[] data = deploy.getBytes("ICON");
        resp.setContentLength(data.length);
        resp.getOutputStream().write(data);
        resp.setContentType("image/png");
        resp.getOutputStream().close();
    }

    private static NotifyServlet.PlatformType getPlatform(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).contains("android")) {
                return NotifyServlet.PlatformType.ANDROID;
            }
            if (userAgent.contains("ipod") || userAgent.contains("ipad") || userAgent.contains("iphone")) {
                return NotifyServlet.PlatformType.IOS;
            }
            if (userAgent.contains("windows")) {
                return NotifyServlet.PlatformType.WINDOWS;
            }
            if (userAgent.contains("macintosh")) {
                return NotifyServlet.PlatformType.MACINTOSH;
            }
        }
        return NotifyServlet.PlatformType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAllAppsPage(HttpServletRequest req, HttpServletResponse resp, String type) throws MXException, IOException {
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        VelocityContext vc = new VelocityContext();
        MboSetRemote appDeploySet = null;
        try {
            appDeploySet = MXServer.getMXServer().getMboSet("IASAPPDEPLOY", MXServer.getMXServer().getSystemUserInfo());
            vc.put("set", (Object)new VelocityMboSet(appDeploySet));
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(appDeploySet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup((MboSetRemote)appDeploySet);
        try {
            String line = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(AppDeployUtil.class.getResourceAsStream("appdeployall-" + type.toLowerCase() + ".html")));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            ve.evaluate((Context)vc, (Writer)resp.getWriter(), VELOCITY_LOG_TAG, sb.toString());
        }
        catch (ParseErrorException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
    }
}

