/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.beans.notifyadm;

import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecUserExpand;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.MXServerRemote;
import psdi.util.MXApplicationException;
import psdi.util.MXApplicationYesNoCancelException;
import psdi.util.MXException;
import psdi.webclient.system.beans.AppBean;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.controller.WebClientEvent;

public class NotifyAdminAppBean
extends AppBean {
    private final NotificationJobManager notificationJobManager = NotificationJobManager.INSTANCE;

    public int REFRESH() throws RemoteException, MXException {
        UserInfo userInfo = this.getMbo().getUserInfo();
        if (userInfo.isInteractive()) {
            int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.REFRESH()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
            switch (userInput) {
                case -1: {
                    throw new MXApplicationYesNoCancelException("informer.REFRESH()", "informer", "confirmRefresh");
                }
                case 8: {
                    break;
                }
                case 16: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
            }
        }
        this.notificationJobManager.enqueue(new JobSpecUserExpand(this.getMbo().getUniqueIDValue()));
        DataBean table = this.app.getDataBean("active_notifications");
        if (table != null) {
            table.refreshTable();
        }
        return 1;
    }

    public int REPRELOAD() throws RemoteException, MXException {
        UserInfo userInfo = this.getMbo().getUserInfo();
        if (userInfo.isInteractive()) {
            int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.REPRELOAD()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
            switch (userInput) {
                case -1: {
                    throw new MXApplicationYesNoCancelException("informer.REPRELOAD()", "informer", "confirmPreRefresh");
                }
                case 8: {
                    break;
                }
                case 16: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
            }
        }
        MboSetRemote catalogSet = this.getMbo().getMboSet("CATALOG");
        EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING);
        MboRemote mbo = catalogSet.moveFirst();
        while (mbo != null) {
            CatalogRemote catalog = (CatalogRemote)mbo;
            if (catalog.getBoolean("PRELOAD")) {
                catalog.preload(evalContext);
            }
            mbo = catalogSet.moveNext();
        }
        catalogSet.save();
        String[] args = new String[]{""};
        this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "preloadStarted", args);
        return 1;
    }

    public int ACTIVATE() throws RemoteException, MXException {
        DataBean appBean = this.app.getAppBean();
        if (appBean.getBoolean("ACTIVE")) {
            Object[] args = new String[]{appBean.getString("NOTIFYNUM")};
            throw new MXApplicationException("informer", "appActive", args);
        }
        if (appBean.toBeSaved()) {
            throw new MXApplicationException("informer", "mustSaveProfileBeforeUse");
        }
        if (appBean.getMbo() != null) {
            final EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING).setFlag(EvalFlags.PROFILE_ACTIVATION);
            SqlFormat sqlf = new SqlFormat(appBean.getMbo(), "notifyid = :notifyid");
            final boolean[] foundNotInitialized = new boolean[]{false};
            MboUtil.visitMbosReadOnly((UserInfo)MXServer.getMXServer().getSystemUserInfo(), (String)"ISCATALOG", (String)sqlf.format(), (NotifyUtil.MboVisitor)new NotifyUtil.MboVisitor(){

                public void visit(@NotNull MboRemote catalog) throws RemoteException, MXException {
                    if (!catalog.getBoolean("INITIALIZED")) {
                        if ("ISPROPERTIES".equalsIgnoreCase(catalog.getString("CATALOG"))) {
                            ((CatalogRemote)catalog).initCatalog(evalContext.duplicate());
                        } else {
                            foundNotInitialized[0] = true;
                        }
                    }
                }
            });
            if (foundNotInitialized[0]) {
                WebClientEvent event = new WebClientEvent("cataloginitialize", this.app.getCurrentPageId(), null, this.clientSession);
                this.clientSession.queueEvent(event);
            } else {
                MboUtil.visitMbosReadOnly((UserInfo)MXServer.getMXServer().getSystemUserInfo(), (String)"ISCATALOG", (String)sqlf.format(), catalog -> {
                    if (catalog instanceof CatalogRemote) {
                        ((CatalogRemote)catalog).reload(evalContext.duplicate());
                    }
                });
                appBean.getMbo().setValue("ACTIVE", true, 2L);
                appBean.refreshTable();
                this.SAVE();
            }
        }
        return 1;
    }

    public int DEACTIVATE() throws RemoteException, MXException {
        DataBean appBean = this.app.getAppBean();
        if (!appBean.getBoolean("ACTIVE")) {
            Object[] args = new String[]{appBean.getString("NOTIFYNUM")};
            throw new MXApplicationException("informer", "appNotActive", args);
        }
        appBean.getMbo().setValue("ACTIVE", false, 2L);
        appBean.getMbo().setFlag(7L, false);
        appBean.refreshTable();
        this.SAVE();
        return 1;
    }
}

