/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.beans.notifyadm;

import com.interlocsolutions.maximo.notify.NotifyUserRemote;
import com.interlocsolutions.maximo.notify.UserNotificationRefresh;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.MXServerRemote;
import psdi.util.MXApplicationYesNoCancelException;
import psdi.util.MXException;
import psdi.webclient.system.beans.AppBean;
import psdi.webclient.system.beans.DataBean;

public class ManageUsersDataBean
extends DataBean {
    public int refreshuser() throws MXException, RemoteException {
        UserInfo userInfo = this.getMbo().getUserInfo();
        if (userInfo.isInteractive()) {
            int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.refreshuser()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
            switch (userInput) {
                case -1: {
                    throw new MXApplicationYesNoCancelException("informer.refreshuser()", "informer", "confirmUserRefresh");
                }
                case 8: {
                    break;
                }
                case 16: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
            }
        }
        if (this.getMbo() != null && this.getMbo() instanceof NotifyUserRemote) {
            new UserNotificationRefresh(this.getMbo().getUniqueIDValue()).start();
        }
        this.reloadTable();
        return 1;
    }

    public int sendapplink() throws MXException, RemoteException {
        MboSetRemote set = this.getMboSet();
        String url = MXServer.getMXServer().getProperty("informer.system.deploy.url");
        if (url == null || url.trim().length() == 0) {
            url = this.clientSession.getMaximoRequestContextURL() + "/notifyexport/appdeploy/";
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (set != null && !set.isEmpty()) {
            if (this.getSelection().size() > 0) {
                ArrayList<String> missingEmails = new ArrayList<String>();
                MboRemote mbo = set.moveFirst();
                while (mbo != null) {
                    if (mbo.isSelected()) {
                        try {
                            ((NotifyUserRemote)mbo).sendAppLink(url);
                        }
                        catch (MXException e) {
                            if ("informer".equals(e.getErrorGroup()) && "userNoemail".equals(e.getErrorKey())) {
                                missingEmails.add(mbo.getString("MAXUSER.USERID"));
                            }
                            throw e;
                        }
                    }
                    mbo = set.moveNext();
                }
                if (missingEmails.isEmpty()) {
                    this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "appLinkSent", null);
                } else {
                    StringBuffer userList = new StringBuffer();
                    for (String user : missingEmails) {
                        if (userList.length() == 0) {
                            userList.append(user);
                            continue;
                        }
                        userList.append(", ").append(user);
                    }
                    String[] args = new String[]{userList.toString()};
                    this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "appLinkNotSent", args);
                }
            } else {
                this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "noUserSelectedforLink", null);
            }
        }
        return 1;
    }

    public int deleteusers() throws MXException, RemoteException {
        MboSetRemote set = this.getMboSet();
        if (set != null && !set.isEmpty()) {
            if (this.getSelection().size() > 0) {
                MboRemote mbo = set.moveFirst();
                while (mbo != null) {
                    if (mbo.isSelected()) {
                        ((NotifyUserRemote)mbo).delete();
                    }
                    mbo = set.moveNext();
                }
                ((AppBean)this.clientSession.getCurrentApp().getAppBean()).save();
            } else {
                this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "noUserSelectedforDelete", null);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyMaximoGroups(MboSetRemote groupSet) throws MXException, RemoteException {
        Vector groups = groupSet.getSelection();
        try {
            this.resetQbe();
            this.getMboSet().reset();
            for (MboRemote group : groups) {
                MboSetRemote userSet = group.getMboSet("GROUPUSER");
                MboRemote user = userSet.moveFirst();
                while (user != null) {
                    String userId = user.getString("USERID");
                    this.addUser(userId);
                    user = userSet.moveNext();
                }
            }
            ((AppBean)this.clientSession.getCurrentApp().getAppBean()).SAVE();
        }
        finally {
            this.getMboSet().reset();
            this.clearfilter();
        }
    }

    private void addUser(String userId) throws MXException, RemoteException {
        if (userId == null) {
            return;
        }
        MboSetRemote set = this.getMboSet();
        MboRemote notifyUser = set.moveFirst();
        while (notifyUser != null) {
            if (userId.equalsIgnoreCase(notifyUser.getString("USERID"))) {
                if (notifyUser.toBeDeleted()) {
                    notifyUser.undelete();
                }
                return;
            }
            notifyUser = set.moveNext();
        }
        notifyUser = set.add();
        notifyUser.setValue("USERID", userId);
    }

    private boolean addUserToGroup(String userId, MboRemote notifyGroup) throws RemoteException, MXException {
        if (userId == null || notifyGroup == null) {
            return false;
        }
        MboSetRemote groupUserSet = notifyGroup.getMboSet("NOTIFYGROUPUSER");
        MboRemote groupUser = groupUserSet.moveFirst();
        while (groupUser != null) {
            if (userId.equals(groupUser.getString("RELATEDUSERID"))) {
                return true;
            }
            groupUser = groupUserSet.moveNext();
        }
        groupUser = groupUserSet.add();
        groupUser.setValue("RELATEDUSERID", userId);
        return true;
    }
}

