/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.beans.notifyadm;

import com.interlocsolutions.maximo.notify.commands.CommandResubmissionUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.Vector;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValue;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.MXServerRemote;
import psdi.util.MXApplicationYesNoCancelException;
import psdi.util.MXException;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.controller.WebClientEvent;
import psdi.webclient.system.runtime.WebClientRuntime;

public class ManageErrorsDataBean
extends DataBean {
    public int cancelDialog() throws MXException, RemoteException {
        MboValue mv = ((Mbo)this.getMbo()).getMboValue("XML");
        this.setValue("XML", mv.getInitialValue().asString());
        this.getMbo().setModified(false);
        return super.cancelDialog();
    }

    public int createincident() throws MXException, RemoteException {
        if (this.getMbo() != null) {
            UserInfo userInfo = this.getMbo().getUserInfo();
            if (userInfo.isInteractive()) {
                int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.createincident()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
                switch (userInput) {
                    case -1: {
                        throw new MXApplicationYesNoCancelException("informer.createincident()", "informer", "confirmsrcreate");
                    }
                    case 8: {
                        break;
                    }
                    case 16: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                }
            }
            String type = MXServer.getMXServer().getProperty("informer.createsrtype") != null ? MXServer.getMXServer().getProperty("informer.createsrtype") : "SR";
            MboSetRemote incidentSet = this.getMbo().getMboSet("$sr", type, "1=1");
            MboRemote incident = incidentSet.add();
            int length = incidentSet.getMboSetInfo().getMboValueInfo("DESCRIPTION").getLength();
            String subject = "Error executing command " + this.getMbo().getString("COMMANDNAME") + " on device " + this.getMbo().getString("DEVICENAME") + "; Serial Number " + this.getMbo().getString("DEVICESERIALNUM");
            if (subject.length() > length) {
                subject = subject.substring(0, length);
            }
            incident.setValue("DESCRIPTION", subject);
            incident.setValue("DESCRIPTION_LONGDESCRIPTION", "Error:\n" + this.getMbo().getString("DETAIL") + "\n\nXML:\n" + this.getMbo().getString("XML"));
            incident.setValue("AFFECTEDPERSON", this.getMbo().getString("PERSON.PERSONID"));
            incident.setValue("SOURCE", "INFORMER");
            incident.setValue("REPORTEDBYID", incident.getUserInfo().getPersonId());
            this.getMbo().setValue("TICKETID", incident.getString("TICKETID"));
            this.getMboSet().save();
            String[] param = new String[]{incident.getString("TICKETID")};
            this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "srcreated", param);
            this.reloadTable();
        }
        return 1;
    }

    public int deleteselected() throws MXException, RemoteException {
        MboSetRemote set = this.getMboSet();
        if (set != null && !set.isEmpty()) {
            if (this.getSelection().size() > 0) {
                MboRemote mbo = set.moveFirst();
                while (mbo != null) {
                    if (mbo.isSelected()) {
                        mbo.delete();
                    }
                    mbo = set.moveNext();
                }
            } else {
                this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "noErrorSelectedforDelete", null);
            }
        }
        this.refreshTable();
        return 1;
    }

    public int retryselected() throws MXException, RemoteException {
        if (this.app.getAppBean().toBeSaved()) {
            this.creatingEvent.getWebClientSession().showMessageBox("informer", "mustSaveProfileBeforeUse", null);
            return 1;
        }
        Vector selection = this.getSelection();
        if (selection.isEmpty()) {
            this.creatingEvent.getWebClientSession().showMessageBox("informer", "noErrorSelectedforRetry", null);
            return 1;
        }
        boolean errors = false;
        for (MboRemote mbo : selection) {
            try {
                CommandResubmissionUtil.resubmitCommandInError((MboRemote)mbo);
            }
            catch (MXException e) {
                NotifyConstants.INFORMER_COMMAND_LOGGER.info((Object)e);
                errors = true;
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_COMMAND_LOGGER.info((Object)e);
                throw e;
            }
        }
        this.app.getAppBean().save();
        if (errors) {
            this.creatingEvent.getWebClientSession().showMessageBox("informer", "errorsDuringRetry", null);
        }
        return 1;
    }

    public int refresh() throws MXException, RemoteException {
        this.getMboSet().reset();
        this.refreshTable();
        return 1;
    }

    public int resubmit() throws MXException, RemoteException {
        try {
            CommandResubmissionUtil.resubmitCommandInError((MboRemote)this.getMbo());
            this.clientSession.showMessageBox("informer", "resubmissionSuccess", null);
            return WebClientRuntime.sendEvent((WebClientEvent)new WebClientEvent("dialogok", this.app.getCurrentPageId(), null, this.clientSession));
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_COMMAND_LOGGER.info((Object)e);
            throw e;
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_COMMAND_LOGGER.info((Object)e);
            throw e;
        }
    }
}

