/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.hash;

import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.LicenseSigner;
import com.interlocsolutions.maximo.notify.util.hash.LicenseHashGenerator;
import com.interlocsolutions.maximo.notify.util.hash.LicenseV1HashGenerator;
import com.interlocsolutions.maximo.notify.util.hash.LicenseV2HashGenerator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class AbstractLicenseHashGenerator
implements LicenseHashGenerator {
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCNTShMlIyZMK+dWgYM/N5qE+4V7fvr/HeYT1YCq1gX0HaGjhTdGMMvZRNi9MFj3lapSNgRbTTpkpVpOvjsOIQizhCY76FyJ80OdKI3YSpVA4DvOOdibDJvCaCwUzzilULkFGxAZNaAEjakq5en4LeQvb8NVLwX74cwtm1uma82GwIDAQAB";
    public static final String PROP_INFORMER_SIGNING_KEY = "INFORMER_SIGNING_KEY";
    public static final String PRIVATE_KEY_FILE = "/com/interlocsolutions/maximo/notify/util/license.key";
    private final int digestLength;

    public AbstractLicenseHashGenerator(int digestLength) {
        this.digestLength = digestLength;
    }

    @Override
    public String generateHash(License license) {
        try {
            MessageDigest msgDigest = this.newMessageDigest();
            byte[] digest = this.generateDigest(msgDigest, license);
            Cipher cipher = this.newCipher(1, this.newPrivateKey(this.newKeyFactory(), this.newPrivateKeySpec()));
            byte[] enc = cipher.doFinal(digest);
            return this.encodeBase64String(enc);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] generateDigest(License license) {
        try {
            return this.generateDigest(this.newMessageDigest(), license);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String generateOverrideKey(License license) {
        try {
            MessageDigest msgDigest = this.newMessageDigest();
            byte[] digest = this.generateOverrideDigest(msgDigest, license);
            Cipher cipher = this.newCipher(1, this.newPrivateKey(this.newKeyFactory(), this.newPrivateKeySpec()));
            byte[] enc = cipher.doFinal(digest);
            return this.encodeBase64String(enc);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] generateOverrideDigest(License license) {
        try {
            return this.generateOverrideDigest(this.newMessageDigest(), license);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] decryptHash(String hash) {
        try {
            Cipher cipher = this.newCipher(2, this.newPublicKey(this.newKeyFactory(), this.newPublicKeySpec()));
            byte[] decryptedHash = cipher.doFinal(this.decodeBase64(hash));
            if (decryptedHash.length < this.getDigestLength()) {
                byte[] rc = new byte[this.getDigestLength()];
                System.arraycopy(decryptedHash, 0, rc, this.getDigestLength() - decryptedHash.length, decryptedHash.length);
                return rc;
            }
            return Arrays.copyOfRange(decryptedHash, decryptedHash.length - this.getDigestLength(), decryptedHash.length);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    protected KeyFactory newKeyFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyFactory.getInstance("RSA", "BC");
    }

    protected EncodedKeySpec newPrivateKeySpec() {
        try {
            URL keyUrl = System.getProperties().containsKey(PROP_INFORMER_SIGNING_KEY) ? new File(System.getProperty(PROP_INFORMER_SIGNING_KEY)).toURI().toURL() : (System.getenv().containsKey(PROP_INFORMER_SIGNING_KEY) ? new File(System.getenv(PROP_INFORMER_SIGNING_KEY)).toURI().toURL() : LicenseSigner.class.getResource(PRIVATE_KEY_FILE));
            Objects.requireNonNull(keyUrl, "Unable to find license.key file");
            return new PKCS8EncodedKeySpec(this.decodeBase64(IOUtils.toString((URL)keyUrl)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected EncodedKeySpec newPublicKeySpec() {
        return new X509EncodedKeySpec(this.decodeBase64(PUBLIC_KEY));
    }

    protected PrivateKey newPrivateKey(KeyFactory keyFactory, EncodedKeySpec privateKeySpec) throws InvalidKeySpecException {
        return keyFactory.generatePrivate(privateKeySpec);
    }

    protected PublicKey newPublicKey(KeyFactory keyFactory, EncodedKeySpec publicKeySpec) throws InvalidKeySpecException {
        return keyFactory.generatePublic(publicKeySpec);
    }

    protected Cipher newCipher(int mode, Key key) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Cipher rc = Cipher.getInstance("RSA", "BC");
        rc.init(mode, key);
        return rc;
    }

    protected int getDigestLength() {
        return this.digestLength;
    }

    protected abstract MessageDigest newMessageDigest() throws NoSuchAlgorithmException, NoSuchProviderException;

    protected abstract byte[] generateDigest(MessageDigest var1, License var2);

    protected byte[] generateOverrideDigest(MessageDigest digest, License license) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream das = new DataOutputStream(byteStream);
        try {
            das.writeInt(0);
            if (license.getHash() == null) {
                throw new RuntimeException("Unable to generate an override key for an unsigned license.");
            }
            das.writeUTF(license.getHash());
            das.writeInt(0);
            das.close();
            return digest.digest(byteStream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LicenseHashGenerator newLicenseHashGenerator(License license) {
        AbstractLicenseHashGenerator rc;
        switch (license.getVersion()) {
            case 1: {
                rc = new LicenseV1HashGenerator();
                break;
            }
            case 2: {
                rc = new LicenseV2HashGenerator();
                break;
            }
            default: {
                throw new IllegalStateException(license.getVersion() + " license version is unsupported.");
            }
        }
        return rc;
    }

    protected byte[] decodeBase64(String base64String) {
        return base64String == null ? null : Base64.decodeBase64((byte[])base64String.getBytes(StandardCharsets.UTF_8));
    }

    protected String encodeBase64String(byte[] binaryData) {
        byte[] encodedBytes = Base64.encodeBase64((byte[])binaryData);
        return encodedBytes == null ? null : new String(encodedBytes);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

