/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.hash.AbstractLicenseHashGenerator;
import com.interlocsolutions.maximo.notify.util.hash.LicenseHashGenerator;
import com.interlocsolutions.maximo.notify.util.hash.LicenseV2HashGenerator;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LicenseSigner {
    public static void signLicense(License license) throws Exception {
        license.setVersion(2);
        license.setHash(new LicenseV2HashGenerator().generateHash(license));
    }

    public static void signLicenseFor(License license) {
        LicenseHashGenerator hashGenerator = AbstractLicenseHashGenerator.newLicenseHashGenerator(license);
        license.setHash(hashGenerator.generateHash(license));
    }

    public static String generateOverrideKey(License license) {
        LicenseHashGenerator hashGenerator = AbstractLicenseHashGenerator.newLicenseHashGenerator(license);
        return hashGenerator.generateOverrideKey(license);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

