/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.OverrideKeyAccessor;
import com.interlocsolutions.maximo.notify.util.hash.AbstractLicenseHashGenerator;
import com.interlocsolutions.maximo.notify.util.hash.LicenseHashGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement(name="license", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"userCount", "deviceCount", "expDate", "applications", "development", "licensee", "hash"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class License {
    public static final String PROP_INFORMER_OVERRIDE_KEY = "informer.license.override";
    public static final String NAME_SPACE = "http://www.interlocsolutions.com/maximo/notify";
    private List<String> applications = null;
    private int userCount = -1;
    private int deviceCount = -1;
    private Calendar expDate = null;
    private String development = null;
    private String hash = null;
    private String licensee = null;
    private int version = 1;
    private String invalidReason = null;
    private String comments;
    private static OverrideKeyAccessor overrideKeyAccessor = null;

    public static License getLicense(String xml) throws JAXBException {
        if (xml == null || xml.trim().contentEquals("")) {
            throw new NullPointerException("Missing License");
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{License.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return (License)unmarshaller.unmarshal((Reader)reader);
    }

    public boolean isApplicationValid(String application) {
        return this.applications != null && this.applications.contains(application);
    }

    @XmlElementWrapper(name="applications", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="application", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<String> getApplications() {
        return this.applications;
    }

    public void setApplications(List<String> applications) {
        this.applications = applications;
    }

    public void addApplication(String application) {
        if (this.applications == null) {
            this.applications = new LinkedList<String>();
        }
        this.applications.add(application);
    }

    @XmlElement(name="usercount", namespace="http://www.interlocsolutions.com/maximo/notify")
    public int getUserCount() {
        return this.userCount;
    }

    public void setUserCount(int userCount) {
        this.userCount = userCount;
    }

    @XmlElement(name="expires", namespace="http://www.interlocsolutions.com/maximo/notify")
    public Calendar getExpDate() {
        return this.expDate;
    }

    public LocalDate getExpDateAsLocalDate() {
        return this.expDate == null ? null : LocalDateTime.ofInstant(this.expDate.toInstant(), this.expDate.getTimeZone().toZoneId()).toLocalDate();
    }

    public void setExpDate(Calendar expDate) {
        this.expDate = expDate;
    }

    public void setExpDate(Date expDate) {
        if (expDate == null) {
            this.expDate = null;
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(expDate);
            this.expDate = c;
        }
    }

    @XmlElement(name="development", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getDevelopment() {
        return this.development;
    }

    public boolean isForDevelopment() {
        return this.development != null && this.development.equalsIgnoreCase("true");
    }

    public void setDevelopment(String development) {
        this.development = development;
    }

    public void setDevelopment(boolean development) {
        this.development = development ? "true" : "false";
    }

    @XmlElement(name="hash", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean isValid() {
        boolean rc;
        this.invalidReason = null;
        LocalDate now = LocalDate.now();
        if (this.isOverridePresent()) {
            if (!this.isOverrideValid()) {
                this.invalidReason = "The override key is invalid.";
                return false;
            }
        } else {
            if (this.isForDevelopment()) {
                this.invalidReason = "Development licenses are no longer valid.";
                return false;
            }
            if (this.getExpDateAsLocalDate() == null && this.getDeviceCount() < 0 && this.getUserCount() < 0) {
                this.invalidReason = "Unlimited licenses are no longer valid.";
                return false;
            }
        }
        if (this.getExpDateAsLocalDate() != null && this.getExpDateAsLocalDate().isBefore(now)) {
            this.invalidReason = "License has expired.";
            return false;
        }
        try {
            LicenseHashGenerator hashGenerator = AbstractLicenseHashGenerator.newLicenseHashGenerator(this);
            byte[] calculatedDigest = hashGenerator.generateDigest(this);
            byte[] decryptedDigest = hashGenerator.decryptHash(this.getHash());
            rc = Arrays.equals(calculatedDigest, decryptedDigest);
            if (!rc) {
                this.invalidReason = "The hash does not match.";
            }
        }
        catch (Exception e) {
            this.invalidReason = e.getMessage();
            rc = false;
        }
        return rc;
    }

    private boolean isOverridePresent() {
        return overrideKeyAccessor != null && overrideKeyAccessor.getOverrideKey() != null;
    }

    private boolean isOverrideValid() {
        boolean rc;
        if (this.isOverridePresent()) {
            String overrideKey = overrideKeyAccessor.getOverrideKey();
            LicenseHashGenerator hashGenerator = AbstractLicenseHashGenerator.newLicenseHashGenerator(this);
            byte[] calculatedOverrideDigest = hashGenerator.generateOverrideDigest(this);
            byte[] decryptedOverrideDigest = hashGenerator.decryptHash(overrideKey);
            rc = Arrays.equals(calculatedOverrideDigest, decryptedOverrideDigest);
        } else {
            rc = false;
        }
        return rc;
    }

    public String toString() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{License.class});
            Marshaller marshaller = jc.createMarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            marshaller.marshal((Object)this, (Node)document);
            if (this.comments != null) {
                Comment comment = document.createComment(String.format(" %s ", this.comments));
                document.insertBefore(comment, document.getFirstChild());
            }
            StringWriter writer = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("standalone", "yes");
            t.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(writer);
            t.transform(source, result);
            return writer.toString();
        }
        catch (JAXBException | ParserConfigurationException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    @XmlElement(name="licensee", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getLicensee() {
        return this.licensee;
    }

    public void setLicensee(String licensee) {
        this.licensee = licensee;
    }

    @XmlTransient
    public String getApplicationList() {
        if (this.applications == null || this.applications.size() == 0) {
            return "";
        }
        if (this.applications.size() == 1) {
            return "'" + this.applications.get(0) + "'";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : this.applications) {
            if (i == 0) {
                sb.append("'").append(s).append("'");
            } else {
                sb.append(",'").append(s).append("'");
            }
            ++i;
        }
        return sb.toString();
    }

    @XmlElement(name="devicecount", namespace="http://www.interlocsolutions.com/maximo/notify")
    public int getDeviceCount() {
        return this.deviceCount;
    }

    public void setDeviceCount(int deviceCount) {
        this.deviceCount = deviceCount;
    }

    @XmlAttribute(name="version")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getInvalidReason() {
        return this.invalidReason;
    }

    public static void setOverrideKeyAccessor(OverrideKeyAccessor accessor) {
        overrideKeyAccessor = accessor;
    }

    public static OverrideKeyAccessor getOverrideKeyAccessor() {
        return overrideKeyAccessor;
    }

    @XmlTransient
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }
}

